#!/usr/local/bin/perl
# index.cgi
# Show the shell user interface

require './shell-lib.pl';
%access = &get_module_acl();
&ReadParse();
&header($text{'index_title'}, "", undef, 0, 1, undef, undef, undef,
	"onLoad='window.scroll(0, 10000); document.forms[0].cmd.focus()'");
print "<hr>\n";

@pprevious = @previous = split(/\0/, $in{'previous'});
$cmd = $in{'doprev'} ? $in{'pcmd'} : $in{'cmd'};

if ($in{'pwd'}) {
	$pwd = $in{'pwd'};
	}
else {
	local @uinfo = getpwnam($access{'user'} || $remote_user);
	$pwd = scalar(@uinfo) && -d $uinfo[7] ? $uinfo[7] : "/";
	}
if (!$in{'clear'}) {
	$history = &un_urlize($in{'history'});
	if ($cmd) {
		# Execute the latest command
		chdir($pwd);
		$history .= "<b>&gt; ".&html_escape($cmd)."</b>\n";
		if ($cmd =~ /^cd\s+(.*)$/) {
			if (!chdir($1)) {
				$history .= &html_escape("$1: $!\n");
				}
			else {
				chop($pwd = `pwd`);
				}
			}
		else {
			local $user = $access{'user'} || $remote_user;
			if ($user eq 'root') {
				$out = `($cmd) 2>&1`;
				}
			else {
				$cmd = quotemeta($cmd);
				$out = `su "$user" -c $cmd 2>&1`;
				}
			$out = &html_escape($out);
			$history .= $out;
			}
		@previous = &unique(@previous, $cmd);
		}
	}

# Show the history and command input
if ($history) {
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'index_history'}</b></td> </tr>\n";
	print "<tr $cb> <td><pre>";
	print $history;
	print "</pre></td></tr> </table><p>\n";
	print "<hr>\n";
	}

print "$text{'index_desc'}<br>\n";
print "<form action=index.cgi method=post>\n";
print "<table width=100%><tr>\n";
print "<td><input type=submit value='$text{'index_ok'}'></td>\n";
print "<td><input name=cmd size=50></td>\n";
print "<td align=right><input type=submit name=clear ",
      "value='$text{'index_clear'}'></td>\n";
print "</tr>\n";
print "<input type=hidden name=pwd value='$pwd'>\n";
print "<input type=hidden name=history value='",&urlize($history),"'>\n";
foreach $p (@previous) {
	print "<input type=hidden name=previous value='",
	      &html_escape($p),"'>\n";
	}

if (@previous) {
	print "<tr> <td><input name=doprev type=submit value='$text{'index_pok'}'></td>\n";
	print "<td><select name=pcmd>\n";
	foreach $p (reverse(@previous)) {
		printf "<option>%s\n", &html_escape($p);
		}
	print "</select></td> </tr>\n";
	}
print "</table>\n";
print "</form>\n";

print "<hr>\n";
&footer("/", $text{'index'});

