#!/usr/local/bin/perl
# search.cgi
# Display a list of packages where the name or description matches some string

require './software-lib.pl';
&ReadParse();

$in{'search'} || &error($text{'search_esearch'});
if (defined(&package_search)) {
	# Use system-specific search function
	$n = &package_search($in{'search'});
	@match = ( 0 .. $n-1 ) if ($n);
	}
else {
	# Search manually through entire list
	$n = &list_packages();
	$s = $in{'search'};
	for($i=0; $i<$n; $i++) {
		if ($packages{$i,'name'} =~ /\Q$s\E/i ||
		    $packages{$i,'desc'} =~ /\Q$s\E/i) {
			push(@match, $i);
			}
		}
	}
if (@match == 1) {
	$p = $packages{$match[0],'name'};
	$v = $packages{$match[0],'version'};
	&redirect("edit_pack.cgi?package=".&urlize($p)."&version=".&urlize($v));
	exit;
	}

&header($text{'search_title'}, "", "search");
print "<hr>\n";
if (@match) {
	@match = sort { lc($packages{$a,'name'}) cmp lc($packages{$b,'name'}) }
		      @match;
	print "<h3>",&text('search_match', "<tt>$s</tt>"),"</h3>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'search_pack'}</b></td> ",
	      "<td><b>$text{'search_class'}</b></td> ",
	      "<td><b>$text{'search_desc'}</b></td> </tr>\n";
	foreach $i (@match) {
		print "<tr $cb>\n";
		print "<td><a href=\"edit_pack.cgi?search=$s&package=",
		      &urlize($packages{$i,'name'}),"&version=",
		      &urlize($packages{$i,'version'}),"\">",&html_escape(
			$packages{$i,'name'}.($packages{$i,'version'} ?
			   " $packages{$i,'version'}" : "")),"</a></td>\n";
		$c = $packages{$i,'class'};
		print "<td>",$c ? &html_escape($c)
				: $text{'search_none'},"</td>\n";
		print "<td>",&html_escape($packages{$i,'desc'}),"</td>\n";
		print "</tr>\n";
		}
	print "</table><p>\n";
	}
else {
	print "<h3>",&text('search_nomatch', "<tt>$s</tt>"),"</h3>\n";
	}

print "<hr>\n";
&footer("", $text{'index_return'});

