# load-monitor.pl
# Check if the system load exceeds some level

sub get_load_status
{
local @u = &uptime_output();
if (!@u) {
	return { 'up' => -1 }
	}
elsif ($u[$_[0]->{'time'}] >= $_[0]->{'max'}) {
	return { 'up' => 0 }
	}
else {
	return { 'up' => 1,
		 'desc' => "Load is $u[$_[0]->{'time'}]" };
	}
}

sub show_load_dialog
{
print "<tr> <td><b>$text{'load_time'}</b></td> <td>\n";
printf "<input type=radio name=time value=0 %s> $text{'load_1'}\n",
	$_[0]->{'time'} == 0 ? "checked" : "";
printf "<input type=radio name=time value=1 %s> $text{'load_5'}\n",
	$_[0]->{'time'} == 1 ? "checked" : "";
printf "<input type=radio name=time value=2 %s> $text{'load_15'}\n",
	$_[0]->{'time'} == 2 ? "checked" : "";
print "</td>\n";

print "<td><b>$text{'load_max'}</b></td>\n";
print "<td><input name=max size=6 value='$_[0]->{'max'}'></td> </tr>\n";
}

sub parse_load_dialog
{
&has_command("uptime") || &error($text{'load_ecmd'});
scalar(&uptime_output()) || &error($text{'load_efmt'});
$in{'max'} =~ /^[0-9\.]+$/ || &error($text{'load_emax'});
$_[0]->{'time'} = $in{'time'};
$_[0]->{'max'} = $in{'max'};
}

sub uptime_output
{
local $out = `uptime 2>&1`;
return $out =~ /average(s)?:\s+([0-9\.]+),\s+([0-9\.]+),\s+([0-9\.]+)/i ?
		( $2, $3, $4 ) : ( );
}

