# proc-monitor.pl
# Check if some process is running

sub get_proc_status
{
local $found;
&foreign_require("proc", "proc-lib.pl");
foreach $p (&foreign_call("proc", "list_processes")) {
	if ($p->{'args'} =~ /$_[0]->{'cmd'}/i) {
		$found = $p->{'pid'};
		last;
		}
	}
if ($_[0]->{'not'}) {
	if (defined($found)) {
		return { 'up' => 0 };
		}
	else {
		return { 'up' => 1 };
		}
	}
else {
	if (defined($found)) {
		return { 'up' => 1, 'desc' => &text('proc_pid', $found) };
		}
	else {
		return { 'up' => 0 };
		}
	}
}

sub show_proc_dialog
{
print "<tr> <td><b>$text{'proc_cmd'}</b></td>\n";
print "<td><input name=cmd size=30 value='$_[0]->{'cmd'}'></td>\n";

print "<td><b>$text{'proc_not'}</b></td>\n";
printf "<td><input type=radio name=not value=0 %s> %s\n",
	$_[0]->{'not'} ? "" : "checked", $text{'proc_not0'};
printf "<input type=radio name=not value=1 %s> %s</td> </tr>\n",
	$_[0]->{'not'} ? "checked" : "", $text{'proc_not1'};
}

sub parse_proc_dialog
{
&depends_check($_[0], "proc");
$in{'cmd'} || &error($text{'proc_ecmd'});
$_[0]->{'cmd'} = $in{'cmd'};
$_[0]->{'not'} = $in{'not'};
}

