#!/usr/local/bin/perl
# edit_configs.cgi
# Display the configs for a usermin module

require './usermin-lib.pl';
$access{'configs'} || &error($text{'acl_ecannot'});
&ReadParse();
&can_use_module($in{'mod'}) || &error($text{'configs_ecannot'});
&header($text{'configs_title2'}, "");
&get_usermin_miniserv_config(\%miniserv);

&read_file("$config{'usermin_dir'}/$in{'mod'}/config", \%mconfig);
if (-r "$miniserv{'root'}/$in{'mod'}/config.info") {
	# Display config form for the module
	%minfo = &get_usermin_module_info($in{'mod'});
	print "<hr>\n";
	print "<form action=\"save_configs.cgi\">\n";
	print "<input type=hidden name=mod value=\"$in{'mod'}\">\n";
	print "<table border>\n";
	print "<tr $tb> <td><b>",&text('config_header', $minfo{'desc'}),
	      "</b></td> </tr>\n";
	print "<tr $cb> <td><table width=100%>\n";

	# Use config.info to create config inputs
	&read_file("$miniserv{'root'}/$in{'mod'}/config.info",
		   \%info, \@info_order);
	%einfo = %info;
	foreach $o (@lang_order_list) {
		&read_file("$miniserv{'root'}/$in{'mod'}/config.info.$o",
			   \%info, \@info_order);
		}
	@info_order = &unique(@info_order);

	foreach $c (@info_order) {
		@p = split(/,/, $info{$c});
		@ep = split(/,/, $einfo{$c});
		if (scalar(@ep) > scalar(@p)) {
			push(@p, @ep[scalar(@p) .. @ep-1]);
			}
		if ($p[1] == 11) {
			print "<tr><td colspan=3 $tb>\n" ;
			print "\t<b>" . $p[0] . "</b>\n</td></tr>\n" ;
			next;
			}
		print "<tr> <td valign=top><b>$p[0]</b></td>\n";
		print "<td nowrap>\n";
		$qw = $mconfig{$c} =~ /'/ ? '"' : "'";
		if ($p[1] == 0) {
			$size = $p[2] ? "size=$p[2]" : "size=40";
			$max = $p[3] ? "maxlength=$p[3]" : "";
			print "<input name=\"$c\" $size $max value=$qw$mconfig{$c}$qw>\n";
			}
		elsif ($p[1] == 1) {
			for($i=2; $i<@p; $i++) {
				$p[$i] =~ /^(\S*)\-(.*)$/;
				printf "<input type=radio name=\"$c\" value='$1' %s>\n",
					$mconfig{$c} eq $1 ? "checked" : "";
				print "$2 &nbsp;&nbsp;\n";
				}
			}
		elsif ($p[1] == 2) {
			local %sel;
			map { $sel{$_}++ } split(/,/, $mconfig{$c});
			print "<select name=\"$c\" size=4 multiple>\n";
			for($i=2; $i<@p; $i++) {
				$p[$i] =~ /^(\S+)\-(.*)$/;
				printf "<option value=\"$1\" %s>$2\n",
					$sel{$1} ? "selected" : "";
				}
			print "</select>\n";
			}
		elsif ($p[1] == 3) {
			$none = $p[2] ? $p[2] : $text{'config_none'};
			printf "<input type=radio name=\"%s_none\" value=1 %s> $none\n",
				$c, $mconfig{$c} eq "" ? "checked" : "";
			print "&nbsp;&nbsp;\n";
			printf "<input type=radio name=\"%s_none\" value=0 %s>\n",
				$c, $mconfig{$c} eq "" ? "" : "checked";
			print "<input name=\"$c\" size=20 value=$qw$mconfig{$c}$qw>\n";
			}
		elsif ($p[1] == 4) {
			print "<select name=\"$c\">\n";
			for($i=2; $i<@p; $i++) {
				$p[$i] =~ /^(\S+)\-(.*)$/;
				printf "<option value=\"$1\" %s>$2\n",
					$mconfig{$c} eq $1 ? "selected" : "";
				}
			print "</select>\n";
			}
		elsif ($p[1] == 5) {
			if ($p[2]) {
				printf
				   "<input type=radio name=${c}_def value=1 %s>$p[2]\n",
				   $mconfig{$c} eq "" ? "checked" : "";
				printf "<input type=radio name=${c}_def value=0 %s>\n",
				   $mconfig{$c} eq "" ? "" : "checked";
				}
			print &unix_user_input($c, $mconfig{$c});
			}
		elsif ($p[1] == 6) {
			if ($p[2]) {
				printf
				   "<input type=radio name=${c}_def value=1 %s>$p[2]\n",
				   $mconfig{$c} eq "" ? "checked" : "";
				printf "<input type=radio name=${c}_def value=0 %s>\n",
				   $mconfig{$c} eq "" ? "" : "checked";
				}
			print &unix_group_input($c, $mconfig{$c});
			}
		elsif ($p[1] == 7) {
			print "<input name=\"$c\" size=40 value=$qw$mconfig{$c}$qw> ",
			      &file_chooser_button($c, 1);
			}
		elsif ($p[1] == 8) {
			print "<input name=\"$c\" size=40 value=$qw$mconfig{$c}$qw> ",
			      &file_chooser_button($c, 0);
			}
		elsif ($p[1] == 9) {
			local $cols = $p[2] ? $p[2] : 40;
			local $rows = $p[3] ? $p[3] : 5;
			local $sp = $p[4] ? eval "\"$p[4]\"" : " ";
			print "<textarea name=\"$c\" rows=$rows cols=$cols>",
				join("\n", split(/$sp/, $mconfig{$c})),
				"</textarea>\n";
			}
		elsif ($p[1] == 10) {
			local $fv = $mconfig{$c};
			for($i=2; $i<@p; $i++) {
				($p[$i] =~ /^(\S*)\-(.*)$/) || next;
				printf "<input type=radio name=\"$c\" value=\"$1\" %s>\n",
					$mconfig{$c} eq $1 ? "checked" : "";
				print "$2 &nbsp;&nbsp;\n";
				$fv = undef if ($mconfig{$c} eq $1);
				}
			printf "<input type=radio name=\"$c\" value=free %s>\n",
				$fv ? "checked" : "";
			if ($p[$#p] !~ /^(\S*)\-(.*)$/) {
				print $p[$#p],"\n";
				}
			print "<input name=\"${c}_free\" value='$fv'>\n";
			}
		print "</td> </tr>\n";
		}
	print "</table></td></tr></table>\n";
	print "<input type=submit value=\"$text{'save'}\"></form>\n";
	}

if (-r "$miniserv{'root'}/$in{'mod'}/uconfig.info") {
	# Display default user config form for the module
	%minfo = &get_usermin_module_info($in{'mod'});
	print "<hr>\n";
	print "<form action=\"save_uconfigs.cgi\">\n";
	print "<input type=hidden name=mod value=\"$in{'mod'}\">\n";
	print "<table border>\n";
	print "<tr $tb> <td><b>",&text('configs_uheader', $minfo{'desc'}),
	      "</b></td> </tr>\n";
	print "<tr $cb> <td><table width=100%>\n";
	&read_file("$miniserv{'root'}/$in{'mod'}/defaultuconfig", \%uconfig);
	&read_file("$config{'usermin_dir'}/$in{'mod'}/uconfig", \%uconfig);

	print "<tr> <td valign=top><b>$text{'configs_prefs'}</b></td> <td>\n";
	printf "<input type=radio name=noprefs value=0 %s> %s\n",
		$mconfig{'noprefs'} ? "" : "checked", $text{'yes'};
	printf "<input type=radio name=noprefs value=1 %s> %s</td> </tr>\n",
		$mconfig{'noprefs'} ? "checked" : "", $text{'no'};
	print "<tr> <td colspan=2><hr></td> </tr>\n";

	# Use uconfig.info to create config inputs
	&read_file("$miniserv{'root'}/$in{'mod'}/uconfig.info",
		   \%uinfo, \@uinfo_order);
	%einfo = %uinfo;
	&read_file("$miniserv{'root'}/$in{'mod'}/uconfig.info.$current_lang",
		   \%uinfo, \@uinfo_order);
	@uinfo_order = &unique(@uinfo_order);

	foreach $c (@uinfo_order) {
		@p = split(/,/, $uinfo{$c});
		@ep = split(/,/, $einfo{$c});
		if (scalar(@ep) > scalar(@p)) {
			push(@p, @ep[scalar(@p) .. @ep-1]);
			}
		if ($p[1] == 11) {
			print "<tr><td colspan=2 $tb>\n" ;
			print "\t<b>" . $p[0] . "</b>\n</td></tr>\n" ;
			next;
			}
		print "<tr> <td valign=top><b>$p[0]</b></td>\n";
		print "<td nowrap>\n";
		$qw = $uconfig{$c} =~ /'/ ? '"' : "'";
		if ($p[1] == 0) {
			$size = $p[2] ? "size=$p[2]" : "size=40";
			$max = $p[3] ? "maxlength=$p[3]" : "";
			print "<input name=\"$c\" $size $max value=$qw$uconfig{$c}$qw>\n";
			}
		elsif ($p[1] == 1) {
			for($i=2; $i<@p; $i++) {
				$p[$i] =~ /^(\S*)\-(.*)$/;
				printf "<input type=radio name=\"$c\" value='$1' %s>\n",
					$uconfig{$c} eq $1 ? "checked" : "";
				print "$2 &nbsp;&nbsp;\n";
				}
			}
		elsif ($p[1] == 2) {
			local %sel;
			map { $sel{$_}++ } split(/,/, $uconfig{$c});
			print "<select name=\"$c\" size=4 multiple>\n";
			for($i=2; $i<@p; $i++) {
				$p[$i] =~ /^(\S+)\-(.*)$/;
				printf "<option value=\"$1\" %s>$2\n",
					$sel{$1} ? "selected" : "";
				}
			print "</select>\n";
			}
		elsif ($p[1] == 3) {
			$none = $p[2] ? $p[2] : $text{'config_none'};
			printf "<input type=radio name=\"%s_none\" value=1 %s> $none\n",
				$c, $uconfig{$c} eq "" ? "checked" : "";
			print "&nbsp;&nbsp;\n";
			printf "<input type=radio name=\"%s_none\" value=0 %s>\n",
				$c, $uconfig{$c} eq "" ? "" : "checked";
			print "<input name=\"$c\" size=20 value=$qw$uconfig{$c}$qw>\n";
			}
		elsif ($p[1] == 4) {
			print "<select name=\"$c\">\n";
			for($i=2; $i<@p; $i++) {
				$p[$i] =~ /^(\S+)\-(.*)$/;
				printf "<option value=\"$1\" %s>$2\n",
					$uconfig{$c} eq $1 ? "selected" : "";
				}
			print "</select>\n";
			}
		elsif ($p[1] == 5) {
			if ($p[2]) {
				printf
				   "<input type=radio name=${c}_def value=1 %s>$p[2]\n",
				   $uconfig{$c} eq "" ? "checked" : "";
				printf "<input type=radio name=${c}_def value=0 %s>\n",
				   $uconfig{$c} eq "" ? "" : "checked";
				}
			print &unix_user_input($c, $uconfig{$c});
			}
		elsif ($p[1] == 6) {
			if ($p[2]) {
				printf
				   "<input type=radio name=${c}_def value=1 %s>$p[2]\n",
				   $uconfig{$c} eq "" ? "checked" : "";
				printf "<input type=radio name=${c}_def value=0 %s>\n",
				   $uconfig{$c} eq "" ? "" : "checked";
				}
			print &unix_group_input($c, $uconfig{$c});
			}
		elsif ($p[1] == 7) {
			print "<input name=\"$c\" size=40 value=$qw$uconfig{$c}$qw> ",
			      &file_chooser_button($c, 1);
			}
		elsif ($p[1] == 8) {
			print "<input name=\"$c\" size=40 value=$qw$uconfig{$c}$qw> ",
			      &file_chooser_button($c, 0);
			}
		elsif ($p[1] == 9) {
			local $cols = $p[2] ? $p[2] : 40;
			local $rows = $p[3] ? $p[3] : 5;
			print "<textarea name=\"$c\" rows=$rows cols=$cols>",
				join("\n", split(/\s+/, $uconfig{$c})),
				"</textarea>\n";
			}
		elsif ($p[1] == 10) {
			local $fv = $uconfig{$c};
			for($i=2; $i<@p; $i++) {
				($p[$i] =~ /^(\S*)\-(.*)$/) || next;
				printf "<input type=radio name=\"$c\" value=\"$1\" %s>\n",
					$uconfig{$c} eq $1 ? "checked" : "";
				print "$2 &nbsp;&nbsp;\n";
				$fv = undef if ($uconfig{$c} eq $1);
				}
			printf "<input type=radio name=\"$c\" value=free %s>\n",
				$fv ? "checked" : "";
			if ($p[$#p] !~ /^(\S*)\-(.*)$/) {
				print $p[$#p],"\n";
				}
			print "<input name=\"${c}_free\" value='$fv'>\n";
			}
		print "</td> </tr>\n";
		}
	print "</table></td></tr></table>\n";
	print "<input type=submit value=\"$text{'save'}\"></form>\n";
	}

print "<hr>\n";
&footer("list_configs.cgi", $text{'configs_return'});

