#!/usr/local/bin/perl
# save_uconfigs.cgi
# Save default user inputs from edit_configs.cgi

require './usermin-lib.pl';
$access{'configs'} || &error($text{'acl_ecannot'});
&ReadParse();
&can_use_module($in{'mod'}) || &error($text{'configs_ecannot'});
$m = $in{'mod'};
&error_setup($text{'config_err'});

&get_usermin_miniserv_config(\%miniserv);
&read_file("$miniserv{'root'}/$m/uconfig.info", \%uinfo, \@uinfo_order) ||
	&error($text{'config_ecannot'});
&read_file("$miniserv{'root'}/$m/uconfig.info.$gconfig{'lang'}", \%uinfo, \@uinfo_order);
@uinfo_order = &unique(@uinfo_order);

mkdir("$config{'usermin_dir'}/$m", 0700);
&lock_file("$config{'usermin_dir'}/$m/uconfig");
&read_file("$config{'usermin_dir'}/$m/uconfig", \%uconfig);

# Use config.info to parse config inputs
foreach $c (@uinfo_order) {
	@p = split(/,/, $uinfo{$c});
	if ($p[1] == 0 || $p[1] == 7 || $p[1] == 8) {
		# Free text input
		$uconfig{$c} = $in{$c};
		}
	elsif ($p[1] == 1 || $p[1] == 4) {
		# One of many
		$uconfig{$c} = $in{$c};
		}
	elsif ($p[1] == 5 || $p[1] == 6) {
		# User or group
		$uconfig{$c} = ($p[2] && $in{$c."_def"} ? "" : $in{$c});
		}
	elsif ($p[1] == 2) {
		# Many of many
		$in{$c} =~ s/\0/,/g;
		$uconfig{$c} = $in{$c};
		}
	elsif ($p[1] == 3) {
		# Optional free text
		if ($in{$c."_none"}) { $uconfig{$c} = ""; }
		else { $uconfig{$c} = $in{$c}; }
		}
	elsif ($p[1] == 9) {
		# Multilines of free text
		$in{$c} =~ s/\n/ /g;
		$in{$c} =~ s/\s+$//;
		$uconfig{$c} = $in{$c};
		}
	elsif ($p[1] == 10) {
		# One of many or free text
		if ($in{$c} eq 'free') {
			$uconfig{$c} = $in{$c.'_free'};
			}
		else {
			$uconfig{$c} = $in{$c};
			}
		}
	}
&write_file("$config{'usermin_dir'}/$m/uconfig", \%uconfig);
&unlock_file("$config{'usermin_dir'}/$m/uconfig");

# Save the preferences config as well
mkdir("$config{'usermin_dir'}/$m", 0700);
&lock_file("$config{'usermin_dir'}/$m/config");
&read_file("$config{'usermin_dir'}/$m/config", \%mconfig);
$mconfig{'noprefs'} = $in{'noprefs'};
&write_file("$config{'usermin_dir'}/$m/config", \%mconfig);
&unlock_file("$config{'usermin_dir'}/$m/config");

&webmin_log("uconfig", undef, undef, \%in);
&redirect("");

