#!/usr/local/bin/perl
# index.cgi
# Display available apache or squid logfiles

require './webalizer-lib.pl';

# Check if webalizer is actually installed
if (!&has_command($config{'webalizer'})) {
	&header($text{'index_title'}, "", undef, 1, 1, 0,
		&help_search_link("webalizer", "man", "doc", "google"));
	print "<hr>\n";
	print "<p>",&text('index_ewebalizer', "<tt>$config{'webalizer'}</tt>",
		  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Get the version number
$out = `$config{'webalizer'} -v 2>&1`;
if ($out !~ /\sV(\S+)/) {
	&header($text{'index_title'}, "", undef, 1, 1, 0,
		&help_search_link("webalizer", "man", "doc", "google"));
	print "<hr>\n";
	print "<p>",&text('index_egetversion',
			  "<tt>$config{'webalizer'} -v</tt>",
			  "<pre>$out</pre>"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}
&header($text{'index_title'}, "", undef, 1, 1, 0,
	&help_search_link("webalizer", "man", "doc", "google"),
	undef, undef, &text('index_version', "$1"));
print "<hr>\n";
if ($1 < 2) {
	print "<p>",&text('index_eversion', "<tt>$config{'webalizer'}</tt>",
			  "$1", "2.0"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Check if the config file exists
if (!-r $config{'webalizer_conf'} && -r $config{'alt_conf'}) {
	# No, but the sample one does
	system("cp '$config{'alt_conf'}' '$config{'webalizer_conf'}' >/dev/null 2>&1");
	}
if (!-r $config{'webalizer_conf'}) {
	print "<p>",&text('index_econf', "<tt>$config{'webalizer_conf'}</tt>",
		  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Query apache and squid for their logfiles
%auto = map { $_, 1 } split(/,/, $config{'auto'});
if (&foreign_check("apache") && $auto{'apache'}) {
	&foreign_require("apache", "apache-lib.pl");
	$conf = &apache::get_config();
	@dirs = ( &apache::find_all_directives($conf, "CustomLog"),
		  &apache::find_all_directives($conf, "TransferLog") );
	$root = &apache::find_directive_struct("ServerRoot", $conf);
	foreach $d (@dirs) {
		local $lf = $d->{'words'}->[0];
		next if ($lf =~ /^\|/);
		if ($lf !~ /^\//) {
			$lf = "$root->{'words'}->[0]/$lf";
			}
		open(FILE, $lf);
		local $line = <FILE>;
		close(FILE);
		if (!$line || $line =~ /^([a-zA-Z0-9\.\-]+)\s+\S+\s+\S+\s+\[\d+\/[a-zA-z]+\/\d+:\d+:\d+:\d+\s+[0-9\+\-]+\]/) {
			push(@logs, { 'file' => $lf,
				      'type' => 1 });
			}
		}
	}
if (&foreign_check("squid") && $auto{'squid'}) {
	&foreign_require("squid", "squid-lib.pl");
	$conf = &squid::get_config();
	$log = &squid::find_value("cache_access_log", $conf);
	$log = "$squid::config{'log_dir'}/access.log"
		if (!$log && -d $squid::config{'log_dir'});
	push(@logs, { 'file' => $log,
		      'type' => 2 }) if ($log);
	}

# Add custom logfiles
push(@logs, map { $_->{'custom'} = 1; $_ } &read_custom_logs());

if (@logs) {
	print "<a href='edit_log.cgi?new=1'>$text{'index_add'}</a>\n"
		if (!$access{'view'} && $access{'add'});
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'index_path'}</b></td> ",
	      "<td><b>$text{'index_type'}</b></td> ",
	      "<td><b>$text{'index_size'}</b></td> ",
	      "<td><b>$text{'index_latest'}</b></td> ",
	      "<td><b>$text{'index_sched'}</b></td> ",
	      "<td><b>$text{'index_rep'}</b></td> </tr>\n";
	foreach $l (@logs) {
		next if ($done{$l->{'file'}}++);
		next if (!&can_edit_log($l->{'file'}));
		local @files = &all_log_files($l->{'file'});
		next if (!@files);
		local $lconf = &get_log_config($l->{'file'});
		print "<tr $cb>\n";
		if ($access{'view'}) {
			print "<td>$l->{'file'}</td>\n";
			}
		else {
			print "<td><a href='edit_log.cgi?file=",
			      &urlize($l->{'file'}),
			      "&type=$l->{'type'}&custom=$l->{'custom'}'>",
			      "$l->{'file'}</a></td>\n";
			}
		print "<td>",&text('index_type'.$l->{'type'}),"</td>\n";
		local ($size, $latest);
		foreach $f (@files) {
			local @st = stat($f);
			$size += $st[7];
			$latest = $st[9] if ($st[9] > $latest);
			}
		$latest = $latest ? localtime($latest) : "<br>";
		print "<td>",$size > 10*1024*1024 ? int($size/1024/1024)." MB" :
			     $size > 10*1024 ? int($size/1024)." KB" :
			     $size ? "$size B" : $text{'index_empty'},"</td>\n";
		print "<td>$latest</td>\n";
		print "<td>",$lconf->{'sched'} ? $text{'yes'}
					       : $text{'no'},"</td>\n";
		if ($lconf->{'dir'} && -r "$lconf->{'dir'}/index.html") {
			print "<td><a href='view_log.cgi/",
			      &urlize(&urlize($l->{'file'})),
			      "/index.html'>$text{'index_view'}</a></td>\n";
			}
		else {
			print "<td><br></td>\n";
			}
		print "</tr>\n";
		}
	print "</table>\n";
	}
else {
	print "<p><b>$text{'index_nologs'}</b><p>\n";
	}
print "<a href='edit_log.cgi?new=1'>$text{'index_add'}</a><br>\n"
	if (!$access{'view'} && $access{'add'});

if (!$access{'view'} && $access{'global'}) {
	print "<hr>\n";
	print "<form action=edit_global.cgi>\n";
	print "<table width=100%><tr>\n";
	print "<td><input type=submit value='$text{'index_global'}'></td>\n";
	print "<td>$text{'index_globaldesc'}</td>\n";
	print "</tr></table></form>\n";
	}

print "<hr>\n";
&footer("/", $text{'index'});

