#!/usr/local/bin/perl
# update.cgi
# Find and install modules that need updating

require './webmin-lib.pl';
&ReadParse();
&error_setup($text{'update_err'});

# Validate inputs
if ($in{'source'} == 0) {
	$host = $update_host;
	$port = $update_port;
	$page = $update_page;
	}
else {
	$in{'other'} =~ /^http:\/\/([^:\/]+)(:(\d+))?(\/\S+)$/ ||
		&error($text{'update_eurl'});
	$host = $1;
	$port = $2 ? $3 : 80;
	$page = $4;
	}

# Retrieve the updates list (format is  module version url support description )
$temp = &tempname();
&http_download($host, $port, $page, $temp);
open(UPDATES, $temp);
while(<UPDATES>) {
	if (/^([^\t]+)\t+([^\t]+)\t+([^\t]+)\t+([^\t]+)\t+(.*)/) {
		push(@updates, [ $1, $2, $3, $4, $5 ]);
		}
	}
close(UPDATES);
unlink($temp);
@updates || &error($text{'update_efile'});

# Display the results and maybe take action
$| = 1;
$theme_no_table = 1;
&header($text{'update_title'}, "");
print "<hr>\n";

print "<b>",&text('update_info'),"</b><p>\n";
foreach $u (@updates) {
	next if ($u->[1] >= &get_webmin_version() + .01 ||
		 $u->[1] < &get_webmin_version());
	$count++;
	local %minfo = &get_module_info($u->[0]);
	local %tinfo = &get_theme_info($u->[0]);
	if (!%minfo && !%tinfo && !$in{'missing'}) {
		print &text('update_mmissing', "<b>$u->[0]</b>"),"<p>\n";
		next;
		}
	if (%minfo && $minfo{'version'} >= $u->[1]) {
		print &text('update_malready', "<b>$u->[0]</b>"),"<p>\n";
		next;
		}
	if (%tinfo && $tinfo{'version'} >= $u->[1]) {
		print &text('update_malready', "<b>$u->[0]</b>"),"<p>\n";
		next;
		}
	local $osinfo = { 'os_support' => $u->[3] };
	if (!&check_os_support($osinfo)) {
		print &text('update_mos', "<b>$u->[0]</b>"),"<p>\n";
		next;
		}
	if ($in{'show'}) {
		# Just tell the user what would be done
		print &text('update_mshow', "<b>$u->[0]</b>", "<b>$u->[1]</b>"),
		      "<br>\n";
		print "&nbsp;" x 10;
		print $u->[4],"<p>\n";
		}
	else {
		# Actually do the update ..
		local (@mdescs, @mdirs, @msizes);
		print &text('update_mok', "<b>$u->[0]</b>", "<b>$u->[1]</b>"),
		      "<br>\n";
		print "&nbsp;" x 10;
		print $u->[4],"<br>\n";
		if ($u->[2] =~ /^http:\/\/([^:\/]+)(:(\d+))?(\/\S+)$/) {
			$mhost = $1;
			$mport = $2 ? $3 : 80;
			$mpage = $4;
			}
		elsif ($u->[2] =~ /^\/\S+$/) {
			$mhost = $host;
			$mport = $port;
			$mpage = $u->[2];
			}
		else {
			$mhost = $host;
			$mport = $port;
			($mpage = $page) =~ s/[^\/]+$//;
			$mpage .= $u->[2];
			}
		$mtemp = &tempname();
		$progress_callback_url = $u->[2];
		$progress_callback_prefix = "&nbsp;" x 10;
		&http_download($mhost, $mport, $mpage, $mtemp, undef,
			       \&progress_callback);
		$irv = &install_webmin_module($mtemp, 1, 0,
					      [ $base_remote_user ]);
		print "&nbsp;" x 10;
		if (!ref($irv)) {
			print &text('update_failed', $irv),"<p>\n";
			}
		else {
			print &text('update_mdesc', "<b>$irv->[0]->[0]</b>",
				    "<b>$irv->[2]->[0]</b>"),"<p>\n";
			}
		}
	}
print &text('update_none'),"<br>\n" if (!$count);

# Check if a new version of webmin itself is available
$file = &tempname();
&http_download('www.webmin.com', 80, '/', $file);
open(FILE, $file);
while(<FILE>) {
	if (/webmin-([0-9\.]+)\.tar\.gz/) {
		$version = $1;
		last;
		}
	}
close(FILE);
unlink($file);
if ($version > &get_webmin_version()) {
	print "<b>",&text('update_version', $version),"</b><p>\n";
	}

print "<p><hr>\n";
&footer("", $text{'index_return'});

