#ifndef XCLASSES_CONFIG_H
#define XCLASSES_CONFIG_H

/*-----------------------------------------------------------------------
 * Xclasses header file
 * 
 * Copyright (C) 1998 Jrgen Schmitz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *-----------------------------------------------------------------------
 */

#include <Xclasses/dlist.h>
#include <Xclasses/Xdisplay.h>
#include <stdio.h>

class config
{
	friend class pconfig;
	class pconfig *p;
public:
	config(char *name);
	virtual ~config();

	void SetItems(struct configopts *);
	void SetDisplayConfig(class Xdisplay *);
	void SetDisplayConfig(class Xdisplay &d) { SetDisplayConfig(&d); };

	void LeaveUnknownLines(void);

	int Read(void);  // 0 - Ok
	int Write(void); // 0 - Ok
	int RootWrite(void); // 0 - Ok
};

struct configopts
{
	char *name;
	char *data;
};

// name pattern: "Xss:name"
// X:  S string - ss: max size
//     T string like S, but if empty or NULL not written
//     I int
//     B bool
//     W switch
//     E enum - ss: enums, ex: "eenum1,enum2,enum3:name", no "-" allowed!
//
// extra options start with "-", e.g. "S-A:name" (but A is currently nothing!)
// absolut path in constructor disables personal config read/write

#endif
