#ifndef INCL_GPOPUP_H
#define INCL_GPOPUP_H

/*-----------------------------------------------------------------------
 * Xclasses header file
 * 
 * Copyright (C) 1998 Jrgen Schmitz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *-----------------------------------------------------------------------
 */

#include <Xclasses/types.h>
#include <Xclasses/Ddraw.h>
#include <Xclasses/Xcolors.h>
#include <Xclasses/gadget.h>
#include <Xclasses/group.h>

class gpopup : public gadget, private Ddraw
{
	friend class pgpopup;
	
	class pgpopup *p;

public:
    virtual void GExpose(XEvent *event);
    virtual void GActionPress(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
    virtual void GActionRelease(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
	virtual void GSetLimits(void);
	virtual int GActivate(XEvent *event,int why);
	virtual int GSelected(XEvent *event,int why,int wasabove);
    virtual int GMouseMove(int mx,int my,int rx,int ry,unsigned int state,int button);

    gpopup();
    virtual ~gpopup();

	int Create();
	void Free(void);

	void Open(int w=0);
	void Open(int x,int y,int w=0);
	void Open(int w,int ax,int ay,int aw,int ah);				// animation
	void Open(int x,int y,int w,int ax,int ay,int aw,int ah);	// animation
	void Close(void);
	
	int GPopupOpen(void);	// 0 - no, 1 - yes
	
	void Resize(int w,int h);
	void Lock(void);
	void Unlock(void);
    void Block(int);
    void Unblock(int);

	void Apply(gadget *);
	void Apply(gadget &g) { Apply(&g); };
	void CloseGadget(gadget *);
	void CloseGadget(gadget &g) { CloseGadget(&g); };

	void Title(char*);
};

#endif
