#ifndef INCL_MXGADGET_H
#define INCL_MXGADGET_H

/*-----------------------------------------------------------------------
 * Xclasses header file
 * 
 * Copyright (C) 1998 Jrgen Schmitz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *-----------------------------------------------------------------------
 */

#include <Xclasses/types.h>
#include <Xclasses/gadget.h>
#include <Xclasses/Ddraw.h>
#include <Xclasses/selgadget.h>

// macro to make an array of pointer to selgadget (x*)[]
// from selgadget array (x[])
// parameters:
//  var     - the selgadget array (e.g. selbutton b[5])
//  count   - number of objects   (e.g. 5)
//  array   - array to write into (e.g. selbutton *pb[6])
//            MUST have one field more!!
#define MakeItems(var,count,array) 	{ for(int i=0;i<count;i++) array[i]=&var[i]; array[count]=NULL; }

class mxgadget : public gadget, private Ddraw
{
	friend class pmxgadget;
	
	class pmxgadget *p;

public:
    virtual void GExpose(XEvent *event);
    virtual void GActionPress(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
    virtual void GActionRelease(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
    virtual int GActivate(XEvent *event,int why);
    virtual int GSelected(XEvent *event,int why,int wasabove);
    virtual void GSetLimits(void);

public:
    mxgadget();
    virtual ~mxgadget();

    int Create(void);
    void Free(void);
    void Items(selgadget **ggs);
    void Horiz(void);
  
    void Selected(int n);
	int  Selected(void);
  
	void Resize(int w,int h);
    void Lock();
    void Unlock();
    void Block(int);
    void Unblock(int);

	void ManageOnly(void);
};

#endif
