#ifndef INCL_SCROLLER_H
#define INCL_SCROLLER_H

/*-----------------------------------------------------------------------
 * Xclasses header file
 * 
 * Copyright (C) 1998 Jrgen Schmitz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *-----------------------------------------------------------------------
 */

#include <Xclasses/types.h>
#include <Xclasses/gadget.h>
#include <Xclasses/Xcolors.h>
#include <Xclasses/Ddraw.h>

class scroller : public gadget, private Ddraw
{
	friend class pscroller;

	class pscroller *p;

public:
    virtual void GExpose(XEvent *event);
    virtual void GActionPress(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
    virtual void GActionRelease(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
    virtual int  GMouseMove(int mx,int my,int rx,int ry,unsigned int state,int button);
    virtual int  GActivate(XEvent *event,int why);
    virtual int  GSelected(XEvent *event,int why,int wasabove);
	virtual void GSetLimits(void);

public:
    scroller();
    virtual ~scroller();

    int Create(void);
    void Free(void);
	void Resize(int w,int h);
	void Lock(void);
	void Unlock(void);
    void Block(int);
    void Unblock(int);

	void Vert(void);
	void Horiz(void);
	void Arrows(void);
	void ArrowStep(int s);
    
    void Items(int);
    void Visible(int);
    void Position(int);
    int Position(void);
};

#endif
