#ifndef INCL_TEXT_H
#define INCL_TEXT_H

/*-----------------------------------------------------------------------
 * Xclasses header file
 * 
 * Copyright (C) 1998 Jrgen Schmitz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *-----------------------------------------------------------------------
 */

#include <Xclasses/types.h>
#include <Xclasses/gadget.h>
#include <Xclasses/Xcolors.h>
#include <Xclasses/Ddraw.h>


class text : public gadget, private Ddraw
{
	friend class ptext;
	
	class ptext *p;

public:
    virtual void GExpose(XEvent *event);
	virtual int GActivate(XEvent *event,int why);
	virtual void GSetLimits(void);

public:
    text(void);
    text(char *);
    virtual ~text();

    int Create(void);
	void Text(char *t);
	
	void OffsetLeft(int);
	void OffsetTop(int);

	void AutoFormat(void);
	void UserFormat(void);
	void FixedText(void);
	void NoUnderline(void);
	
	void Center(void);
	void Left(void);
	void Right(void);
};

typedef text Xclasses_text;

#endif
