#ifndef INCL_LISTGROUP_H
#define INCL_LISTGROUP_H

/*-----------------------------------------------------------------------
 * Xclasses header file
 * 
 * Copyright (C) 1998 Jrgen Schmitz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *-----------------------------------------------------------------------
 */

#include <Xclasses/types.h>
#include <Xclasses/gadget.h>
#include <Xclasses/group.h>
#include <Xclasses/Xcolors.h>

class listgroup : public gadget 
{
	friend class plistgroup;

	class plistgroup *p;

public:
	virtual void GSetLimits(void);
	virtual int GSelected(XEvent *event,int why,int wasabove);

public:
    listgroup();
    virtual ~listgroup();

    virtual int Create(void);
    virtual void Free(void);
    virtual void Resize(int nw,int nh);
    virtual void Lock(void);
    virtual void Unlock(void);
    virtual void Block(int);
    virtual void Unblock(int);

	void Add(char *,group *);
	void Add(char *n,group &g) { Add(n,&g); };

	void Selected(int);
	int Selected(void);
};

#endif
