#ifndef INCL_MESSAGETOOLS_H
#define INCL_MESSAGETOOLS_H

/*-----------------------------------------------------------------------
 * Xclasses header file
 * 
 * Copyright (C) 1998 Jrgen Schmitz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *-----------------------------------------------------------------------
 */

#include <Xclasses/message.h>

// ===================================================================
// msg get classes
// -------------------------------------------------------------------

class msgget_int : public msg_get
{

public:
	msgget_int(callable *classptr,int (callable::*)(void));
	msgget_int(callable *classptr,unsigned int (callable::*)(void));
	virtual ~msgget_int();

	virtual void *get(void);
};
class msgget_char : public msg_get
{
	char *buf;
public:
	msgget_char(callable *classptr,void (callable::*)(char *),int size=64);
	virtual ~msgget_char();

	virtual void *get(void);
};


// ===================================================================
// msg set classes
// -------------------------------------------------------------------

class msgset_int : public msg_set
{

public:
	msgset_int(callable *classptr,void (callable::*)(int));
	msgset_int(callable *classptr,void (callable::*)(unsigned int));
	virtual ~msgset_int();

	virtual void set(void *);
};
class msgset_char : public msg_set
{

public:
	msgset_char(callable *classptr,void (callable::*)(char *));
	virtual ~msgset_char();

	virtual void set(void *);
};


// ===================================================================
// msg conv classes
// -------------------------------------------------------------------

class msgconv_int2char : public msg_conv
{
	char *buf;
public:
	msgconv_int2char();
	virtual ~msgconv_int2char();

	virtual void *conv(void*);
};
class msgconv_char2int : public msg_conv
{
public:
	msgconv_char2int();
	virtual ~msgconv_char2int();

	virtual void *conv(void*);
};

#endif
