#ifndef INCL_XCOLORS_H
#define INCL_XCOLORS_H

/*-----------------------------------------------------------------------
 * Xclasses header file
 * 
 * Copyright (C) 1998 Jrgen Schmitz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *-----------------------------------------------------------------------
 */

#include <Xclasses/types.h>
#include <Xclasses/Xdisplay.h>

class Xcolors : public Xdisplay
{
	friend class pXcolors;

	class pXcolors *p;

public:
	Xcolors(void);
	virtual ~Xcolors(void);

	void SetBase(int r,int g,int b);
	void SetBase(char *colname);

    int Init(char *dsp);
    int Init(int &argc, char *argv[]);
    int Init(int &argc, char *argv[],char *basecolor);
    int Init(void);
    void Close(void);

	Colormap Cmap(void);
	
	unsigned long col_background(void);
	unsigned long col_darkbackground(void);
	unsigned long col_markbackground(void);
	unsigned long col_shinebackground(void);
	unsigned long col_selected(void);
	unsigned long col_active(void);
	unsigned long col_shine(void);
	unsigned long col_shadow(void);
	unsigned long col_shine2(void);
	unsigned long col_shadow2(void);
	unsigned long col_text(void);
	unsigned long col_hitext(void);
	unsigned long col_selectedtext(void);
	unsigned long col_white(void);
	unsigned long col_black(void);

	int ColMode(void);

	unsigned long AllocColor(unsigned short r,unsigned short g,unsigned short b);
	unsigned long AllocColor(char *name);
	void FreeColor(unsigned long);
};

#endif
