/*
   xls2xml: Converts from Microsoft Excel files to XML.
   Copyright 1999  Roberto Arturo Tena Sanchez

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published  by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
/*
   Roberto Arturo Tena Sanchez <arturo@directmail.org>
 */

#ifndef PARAM_H
#define PARAM_H

#ifdef __cplusplus
extern "C" {
#endif


#include <cole1compat.h>
#include <cole/cole.h>
#include <gnome-xml/tree.h>
#include <defines.h>


struct str_magic_parameters
{
  COLEFILE *xlsfile;
  xmlDocPtr * p_xml_doc;
  xmlDocPtr xml_doc;
  /* xmlNsPtr * xlsxmlns; */  /* we don't have namespace */
  struct str_record { 
    U16 opcode;
    U16 size;
    U8 info [MAX_RECORD_SIZE];
    U32 brdb_entry;
  } record;
  int dont_care_end;	/* don't care if, while reading next record, ends xls
			   file, principally because we are wating for the
			   next stream, we are in the middle of two */
  int jump_to_next_substream;	/* we don't want to extract this substream */
  U8 extract_level;	/* see `defines.h' file */
  U16 biff_version;	/* see `defines.h' file */
  int datesystem1904;
  U16 next_font_refnum;
  U16 next_sheet_refnum;
  xmlNodePtr this_sheet;
  xmlNodePtr this_cells;
  int this_refmode;
  U16 code_page;
  struct str_xml_tree_shortcuts {
    /* If you add any, initialize it in xls2xml() */
    xmlNodePtr defaults;
    xmlNodePtr code_page;
    xmlNodePtr ui;
    xmlNodePtr tabs_state;
    xmlNodePtr fonts;
    xmlNodePtr sheets;
    xmlNodePtr window_state;
    xmlNodePtr first_sheet;
  } xml_tree_shortcuts;
  struct str_sst {
    U16 count;
    struct str_sst_string {
      U16 len;
      U8 * string;
    } * strings;
  } sst;
/*
  struct {
    U32 offset;
    xmlNodePtr sheet;
  } * associate_offsets_and_sheets;
*/
  struct str_optios {
    int extract_level;  /* see `defines.h' */
    int refmode;        /* see `defines.h' */
  } options;
}; 
typedef struct str_magic_parameters magic_parameters;
extern magic_parameters * parameters;


#ifdef __cplusplus
}
#endif 

#endif /* PARAM_H */
