## xml-i18n-tools.m4 - Configure xml-i18n-tools for the target system. -*-Shell-script-*-
## Copyright (C) 2001 Eazel, Inc.
## Author: Maciej Stachowiak <mjs@eazel.com>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## As a special exception to the GNU General Public License, if you
## distribute this file as part of a program that contains a
## configuration script generated by Autoconf, you may include it under
## the same distribution terms that you use for the rest of that program.

define([HACK_SUBST], defn([AC_SUBST]))

# serial 1 AC_PROG_XML_I18N_TOOLS
AC_DEFUN(AC_PROG_XML_I18N_TOOLS,
[

dnl This is a hack - we use the expansion of AC_SUBST instead of
dnl AC_SUBST itself to avoid automake putting 
dnl XML_I18N_MERGE_OAF_RULE = @XML_I18N_MERGE_OAF_RULE@
dnl in all the Makefile.in's, because that will blow up when substituted.
XML_I18N_MERGE_OAF_RULE='\%.oaf : \%.oaf.in $(top_builddir)/xml-i18n-merge $(top_srcdir)/po/*.po\
	$(top_builddir)/xml-i18n-merge -o $(top_srcdir)/po $< [$]*.oaf'
HACK_SUBST(XML_I18N_MERGE_OAF_RULE)

XML_I18N_MERGE_SERVER_RULE='\%.server : \%.server.in $(top_builddir)/xml-i18n-merge $(top_srcdir)/po/*.po\
	$(top_builddir)/xml-i18n-merge -o $(top_srcdir)/po $< [$]*.server'
HACK_SUBST(XML_I18N_MERGE_SERVER_RULE)

dnl same deal
XML_I18N_MERGE_KEYS_RULE='\%.keys : \%.keys.in $(top_builddir)/xml-i18n-merge $(top_srcdir)/po/*.po\
	$(top_builddir)/xml-i18n-merge -k $(top_srcdir)/po $< [$]*.keys'
HACK_SUBST(XML_I18N_MERGE_KEYS_RULE)

dnl same deal
XML_I18N_MERGE_DESKTOP_RULE='\%.desktop : \%.desktop.in $(top_builddir)/xml-i18n-merge $(top_srcdir)/po/*.po\
	$(top_builddir)/xml-i18n-merge -d $(top_srcdir)/po $< [$]*.desktop'
HACK_SUBST(XML_I18N_MERGE_DESKTOP_RULE)

dnl same deal
XML_I18N_MERGE_DIRECTORY_RULE='\%.directory : \%.directory.in $(top_builddir)/xml-i18n-merge $(top_srcdir)/po/*.po\
	$(top_builddir)/xml-i18n-merge -d $(top_srcdir)/po $< [$]*.directory'
HACK_SUBST(XML_I18N_MERGE_DIRECTORY_RULE)

dnl same deal
XML_I18N_MERGE_SOUNDLIST_RULE='\%.soundlist : \%.soundlist.in $(top_builddir)/xml-i18n-merge $(top_srcdir)/po/*.po\
	$(top_builddir)/xml-i18n-merge -d $(top_srcdir)/po $< [$]*.soundlist'
HACK_SUBST(XML_I18N_MERGE_SOUNDLIST_RULE)

dnl same deal
XML_I18N_MERGE_PONG_RULE='\%.pong : \%.pong.in $(top_builddir)/xml-i18n-merge $(top_srcdir)/po/*.po\
	$(top_builddir)/xml-i18n-merge -x $(top_srcdir)/po $< [$]*.pong'
HACK_SUBST(XML_I18N_MERGE_PONG_RULE)

dnl same deal
XML_I18N_MERGE_XML_RULE='\%.xml : \%.xml.in $(top_builddir)/xml-i18n-merge $(top_srcdir)/po/*.po\
	$(top_builddir)/xml-i18n-merge -x $(top_srcdir)/po $< [$]*.xml'
HACK_SUBST(XML_I18N_MERGE_XML_RULE)

# Always use our own xml-i18n-tools.
XML_I18N_EXTRACT='$(top_builddir)/xml-i18n-extract'
AC_SUBST(XML_I18N_EXTRACT)dnl

XML_I18N_MERGE='$(top_builddir)/xml-i18n-merge'
AC_SUBST(XML_I18N_MERGE)dnl

XML_I18N_UPDATE='$(top_builddir)/xml-i18n-update'
AC_SUBST(XML_I18N_UPDATE)dnl

AC_PATH_PROG(XML_I18N_TOOLS_PERL, perl)
if test -z "$XML_I18N_TOOLS_PERL"; then
   AC_MSG_ERROR([perl not found; required for xml-i18n-tools])
fi
if test -z "`$XML_I18N_TOOLS_PERL -v | fgrep '5.' 2> /dev/null`"; then
   AC_MSG_ERROR([perl 5.x required for xml-i18n-tools])
fi

dnl  manually sed perl in so people don't have to put the xml-i18n-tools scripts in their 
dnl  AC_OUTPUT
AC_OUTPUT_COMMANDS([
sed -e "s:@XML_I18N_TOOLS_PERL@:${XML_I18N_TOOLS_PERL}:;" < ${srcdir}/xml-i18n-extract.in > xml-i18n-extract;
chmod ugo+x xml-i18n-extract;
chmod u+w xml-i18n-extract;

sed -e "s:@XML_I18N_TOOLS_PERL@:${XML_I18N_TOOLS_PERL}:;" < ${srcdir}/xml-i18n-merge.in > xml-i18n-merge;
chmod ugo+x xml-i18n-merge;
chmod u+w xml-i18n-merge;

sed -e "s:@XML_I18N_TOOLS_PERL@:${XML_I18N_TOOLS_PERL}:;" < ${srcdir}/xml-i18n-update.in > xml-i18n-update;
chmod ugo+x xml-i18n-update;
chmod u+w xml-i18n-update;
], XML_I18N_TOOLS_PERL=${XML_I18N_TOOLS_PERL})

# Redirect the config.log output again, so that the ltconfig log is not
# clobbered by the next message.
exec 5>>./config.log
])

dnl old names
AC_DEFUN(AM_PROG_XML_I18N_TOOLS, [indir([AC_PROG_XML_I18N_TOOLS])])dnl
