/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.RangeExceptionImpl;
import org.apache.xerces.dom.TextImpl;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.range.Range;
import org.w3c.dom.range.RangeException;

public class RangeImpl
implements Range {
    static final int START = 0;
    static final int AFTER = 1;
    static final int BEFORE = -1;
    DocumentImpl fDocument;
    Node fStartContainer;
    Node fEndContainer;
    int fStartOffset;
    int fEndOffset;
    boolean fIsCollapsed;
    boolean fDetach = false;
    Node fInsertNode = null;
    Node fDeleteNode = null;
    Node fSplitNode = null;
    Node fRemoveChild = null;
    static final int EXTRACT_CONTENTS = 1;
    static final int CLONE_CONTENTS = 2;

    public RangeImpl(DocumentImpl documentImpl) {
        this.fDocument = documentImpl;
        this.fStartContainer = documentImpl;
        this.fEndContainer = documentImpl;
        this.fStartOffset = 0;
        this.fEndOffset = 0;
        this.fDetach = false;
    }

    void checkIndex(Node node, int n) throws DOMException {
        if (n < 0) {
            throw new DOMException(1, "DOM004 Index out of bounds");
        }
        short s = node.getNodeType();
        if (s == 3 || s == 4 || s == 8 || s == 7 ? n > node.getNodeValue().length() : n > node.getChildNodes().getLength()) {
            throw new DOMException(1, "DOM004 Index out of bounds");
        }
    }

    public DocumentFragment cloneContents() throws DOMException {
        return this.traverseContents(2);
    }

    public Range cloneRange() {
        if (this.fDetach) {
            throw new DOMException(11, "DOM011 Invalid state");
        }
        Range range = this.fDocument.createRange();
        range.setStart(this.fStartContainer, this.fStartOffset);
        range.setEnd(this.fEndContainer, this.fEndOffset);
        return range;
    }

    public void collapse(boolean bl) {
        if (this.fDetach) {
            throw new DOMException(11, "DOM011 Invalid state");
        }
        if (bl) {
            this.fEndContainer = this.fStartContainer;
            this.fEndOffset = this.fStartOffset;
        } else {
            this.fStartContainer = this.fEndContainer;
            this.fStartOffset = this.fEndOffset;
        }
    }

    public short compareBoundaryPoints(short s, Range range) throws DOMException {
        int n;
        int n2;
        Node node;
        Node node2;
        if (this.fDetach) {
            throw new DOMException(11, "DOM011 Invalid state");
        }
        if (s == 0) {
            node2 = range.getStartContainer();
            node = this.fStartContainer;
            n2 = range.getStartOffset();
            n = this.fStartOffset;
        } else if (s == 1) {
            node2 = range.getStartContainer();
            node = this.fEndContainer;
            n2 = range.getStartOffset();
            n = this.fEndOffset;
        } else if (s == 3) {
            node2 = range.getEndContainer();
            node = this.fStartContainer;
            n2 = range.getEndOffset();
            n = this.fStartOffset;
        } else {
            node2 = range.getEndContainer();
            node = this.fEndContainer;
            n2 = range.getEndOffset();
            n = this.fEndOffset;
        }
        if (node2 == node) {
            if (n2 < n) {
                return -1;
            }
            if (n2 == n) {
                return 0;
            }
            return 1;
        }
        Node node3 = node;
        Node node4 = node3.getParentNode();
        while (node4 != null) {
            if (node4 == node2) {
                int n3 = this.indexOf(node3, node2);
                if (n2 <= n3) {
                    return -1;
                }
                return 1;
            }
            node3 = node4;
            node4 = node4.getParentNode();
        }
        Node node5 = node2;
        Node node6 = node5.getParentNode();
        while (node6 != null) {
            if (node6 == node) {
                int n4 = this.indexOf(node5, node);
                if (n4 < n) {
                    return -1;
                }
                return 1;
            }
            node5 = node6;
            node6 = node6.getParentNode();
        }
        int n5 = 0;
        Node node7 = node2;
        while (node7 != null) {
            ++n5;
            node7 = node7.getParentNode();
        }
        Node node8 = node;
        while (node8 != null) {
            --n5;
            node8 = node8.getParentNode();
        }
        while (n5 > 0) {
            node2 = node2.getParentNode();
            --n5;
        }
        while (n5 < 0) {
            node = node.getParentNode();
            ++n5;
        }
        Node node9 = node2.getParentNode();
        Node node10 = node.getParentNode();
        while (node9 != node10) {
            node2 = node9;
            node = node10;
            node9 = node9.getParentNode();
            node10 = node10.getParentNode();
        }
        Node node11 = node2.getNextSibling();
        while (node11 != null) {
            if (node11 == node) {
                return -1;
            }
            node11 = node11.getNextSibling();
        }
        return 1;
    }

    public void deleteContents() throws DOMException {
        Node node;
        Node node2 = this.fStartContainer;
        Node node3 = null;
        boolean bl = false;
        Node node4 = this.getCommonAncestorContainer();
        if (this.fStartContainer == this.fEndContainer) {
            if (this.fStartOffset == this.fEndOffset) {
                return;
            }
            if (this.fStartContainer.getNodeType() == 3) {
                String string = this.fStartContainer.getNodeValue();
                int n = this.fStartOffset;
                int n2 = this.fEndOffset;
                if (this.fStartOffset > string.length()) {
                    n = string.length() - 1;
                }
                if (this.fEndOffset > string.length()) {
                    n2 = string.length() - 1;
                }
                this.deleteData((CharacterData)this.fStartContainer, n, n2 - n);
            } else {
                node2 = this.fStartContainer.getFirstChild();
                int n = 0;
                n = 0;
                while (n < this.fStartOffset && node2 != null) {
                    node2 = node2.getNextSibling();
                    ++n;
                }
                n = 0;
                while (n < this.fEndOffset - this.fStartOffset && node2 != null) {
                    Node node5 = node2.getNextSibling();
                    this.removeChild(this.fStartContainer, node2);
                    node2 = node5;
                    ++n;
                }
            }
            this.collapse(true);
            return;
        }
        Node node6 = null;
        int n = 0;
        Node node7 = null;
        if (node2.getNodeType() == 3) {
            this.deleteData((CharacterData)node2, this.fStartOffset, node2.getNodeValue().length() - this.fStartOffset);
        } else {
            node2 = node2.getFirstChild();
            int n3 = 0;
            while (n3 < this.fStartOffset && node2 != null) {
                node2 = node2.getNextSibling();
                ++n3;
            }
            if (node2 == null) {
                node2 = this.fStartContainer;
            } else if (node2 != this.fStartContainer) {
                bl = true;
            }
        }
        while (node2 != node4 && node2 != null) {
            node3 = node2.getParentNode();
            if (node3 == node4) {
                if (node7 == null) {
                    node7 = node2;
                }
            } else if (node6 == null) {
                node6 = node3;
                n = 1;
            }
            if (node3 != node4) {
                node = node2.getNextSibling();
                while (node != null) {
                    Node node8 = node.getNextSibling();
                    this.removeChild(node3, node);
                    node = node8;
                }
            }
            if (bl) {
                this.removeChild(node3, node2);
                bl = false;
            }
            node2 = node3;
        }
        Node node9 = null;
        node2 = this.fEndContainer;
        if (node2.getNodeType() == 3) {
            this.deleteData((CharacterData)node2, 0, this.fEndOffset);
        } else if (this.fEndOffset == 0) {
            node2 = this.fEndContainer;
        } else {
            node2 = node2.getFirstChild();
            int n4 = 1;
            while (n4 < this.fEndOffset && node2 != null) {
                node2 = node2.getNextSibling();
                ++n4;
            }
            if (node2 == null) {
                node2 = this.fEndContainer.getLastChild();
            } else if (node2 != this.fStartContainer) {
                bl = true;
            }
        }
        while (node2 != node4 && node2 != null) {
            node3 = node2.getParentNode();
            if (node3 == node4) {
                if (node9 == null) {
                    node9 = node2;
                }
            } else if (node6 == null) {
                node6 = node3;
                n = -1;
            }
            if (node3 != node4 && node3 != null) {
                node = node2.getPreviousSibling();
                while (node != null) {
                    Node node10 = node.getPreviousSibling();
                    this.removeChild(node3, node);
                    node = node10;
                }
            }
            if (bl) {
                this.removeChild(node3, node2);
                bl = false;
            }
            node2 = node3;
        }
        node2 = node9.getPreviousSibling();
        Node node11 = null;
        while (node2 != null && node2 != node7) {
            node11 = node2.getPreviousSibling();
            node3 = node2.getParentNode();
            if (node3 != null) {
                this.removeChild(node3, node2);
            }
            node2 = node11;
        }
        if (node6 == null) {
            this.collapse(true);
        } else if (n == 1) {
            this.setStartAfter(node6);
            this.setEndAfter(node6);
        } else if (n == -1) {
            this.setStartBefore(node6);
            this.setEndBefore(node6);
        }
    }

    void deleteData(CharacterData characterData, int n, int n2) {
        this.fDeleteNode = characterData;
        characterData.deleteData(n, n2);
        this.fDeleteNode = null;
    }

    public void detach() {
        this.fDetach = true;
        this.fDocument.removeRange(this);
    }

    public DocumentFragment extractContents() throws DOMException {
        return this.traverseContents(1);
    }

    public boolean getCollapsed() {
        return this.fStartContainer == this.fEndContainer && this.fStartOffset == this.fEndOffset;
    }

    public Node getCommonAncestorContainer() {
        Vector<Node> vector = new Vector<Node>();
        Node node = this.fStartContainer;
        while (node != null) {
            vector.addElement(node);
            node = node.getParentNode();
        }
        Vector<Node> vector2 = new Vector<Node>();
        node = this.fEndContainer;
        while (node != null) {
            vector2.addElement(node);
            node = node.getParentNode();
        }
        int n = vector.size() - 1;
        int n2 = vector2.size() - 1;
        Object var6_6 = null;
        while (n >= 0 && n2 >= 0) {
            if (vector.elementAt(n) != vector2.elementAt(n2)) break;
            var6_6 = vector.elementAt(n);
            --n;
            --n2;
        }
        return var6_6;
    }

    public Node getEndContainer() {
        return this.fEndContainer;
    }

    public int getEndOffset() {
        return this.fEndOffset;
    }

    public Node getStartContainer() {
        return this.fStartContainer;
    }

    public int getStartOffset() {
        return this.fStartOffset;
    }

    int indexOf(Node node, Node node2) {
        int n = 0;
        if (node.getParentNode() != node2) {
            return -1;
        }
        Node node3 = node;
        while (node3 != null) {
            ++n;
            node3 = node3.getPreviousSibling();
        }
        return n;
    }

    void insertData(CharacterData characterData, int n, String string) {
        this.fInsertNode = characterData;
        characterData.insertData(n, string);
        this.fInsertNode = null;
    }

    public void insertNode(Node node) throws DOMException, RangeException {
        if (node == null) {
            return;
        }
        if (this.fDetach) {
            throw new DOMException(11, "DOM011 Invalid state");
        }
        if (((NodeImpl)this.fStartContainer.getParentNode()).getReadOnly()) {
            throw new DOMException(7, "DOM007 Read Only node");
        }
        if (this.fDocument != node.getOwnerDocument()) {
            throw new DOMException(4, "DOM004 Wrong document");
        }
        if (this.isAncestorOf(node, this.fStartContainer)) {
            throw new DOMException(3, "DOM003 Hierarchy request");
        }
        short s = node.getNodeType();
        if (s == 2 || s == 6 || s == 12 || s == 9) {
            throw new RangeExceptionImpl(2, "DOM012 Invalid node type");
        }
        int n = 0;
        if (this.fStartContainer.getNodeType() == 3) {
            Node node2 = this.fStartContainer.getParentNode();
            n = node2.getChildNodes().getLength();
            Node node3 = this.fStartContainer.cloneNode(false);
            ((TextImpl)node3).setNodeValueInternal(node3.getNodeValue().substring(this.fStartOffset));
            ((TextImpl)this.fStartContainer).setNodeValueInternal(this.fStartContainer.getNodeValue().substring(0, this.fStartOffset));
            Node node4 = this.fStartContainer.getNextSibling();
            if (node4 != null) {
                if (node2 != null) {
                    node2.insertBefore(node, node4);
                    node2.insertBefore(node3, node4);
                }
            } else if (node2 != null) {
                node2.appendChild(node);
                node2.appendChild(node3);
            }
            if (this.fEndContainer == this.fStartContainer) {
                this.fEndContainer = node3;
                this.fEndOffset -= this.fStartOffset;
            } else if (this.fEndContainer == node2) {
                this.fEndOffset += node2.getChildNodes().getLength() - n;
            }
            this.signalSplitData(this.fStartContainer, node3, this.fStartOffset);
        } else {
            if (this.fEndContainer == this.fStartContainer) {
                n = this.fEndContainer.getChildNodes().getLength();
            }
            Node node5 = this.fStartContainer.getFirstChild();
            int n2 = 0;
            n2 = 0;
            while (n2 < this.fStartOffset && node5 != null) {
                node5 = node5.getNextSibling();
                ++n2;
            }
            if (node5 != null) {
                this.fStartContainer.insertBefore(node, node5);
            } else {
                this.fStartContainer.appendChild(node);
            }
            if (this.fEndContainer == this.fStartContainer) {
                this.fEndOffset += this.fEndContainer.getChildNodes().getLength() - n;
            }
        }
    }

    public void insertedNodeFromDOM(Node node) {
        int n;
        if (node == null) {
            return;
        }
        if (this.fInsertNode == node) {
            return;
        }
        Node node2 = node.getParentNode();
        if (node2 == this.fStartContainer && (n = this.indexOf(node, this.fStartContainer)) < this.fStartOffset) {
            ++this.fStartOffset;
        }
        if (node2 == this.fEndContainer && (n = this.indexOf(node, this.fEndContainer)) < this.fEndOffset) {
            ++this.fEndOffset;
        }
    }

    boolean isAncestorOf(Node node, Node node2) {
        Node node3 = node2;
        while (node3 != null) {
            if (node3 == node) {
                return true;
            }
            node3 = node3.getParentNode();
        }
        return false;
    }

    boolean isAncestorTypeValid(Node node) {
        Node node2 = node;
        while (node2 != null) {
            short s = node2.getNodeType();
            if (s == 2 || s == 6 || s == 12 || s == 10) {
                return false;
            }
            node2 = node2.getParentNode();
        }
        return true;
    }

    Node nextNode(Node node, boolean bl) {
        Node node2;
        if (node == null) {
            return null;
        }
        if (bl && (node2 = node.getFirstChild()) != null) {
            return node2;
        }
        node2 = node.getNextSibling();
        if (node2 != null) {
            return node2;
        }
        Node node3 = node.getParentNode();
        while (node3 != null && node3 != this.fDocument) {
            node2 = node3.getNextSibling();
            if (node2 != null) {
                return node2;
            }
            node3 = node3.getParentNode();
        }
        return null;
    }

    void receiveDeletedText(Node node, int n, int n2) {
        if (node == null) {
            return;
        }
        if (this.fDeleteNode == node) {
            return;
        }
        if (node == this.fStartContainer && this.fStartContainer.getNodeType() == 3) {
            if (this.fStartOffset > n + n2) {
                this.fStartOffset = n + (this.fStartOffset - (n + n2));
            } else if (this.fStartOffset > n) {
                this.fStartOffset = n;
            }
        }
        if (node == this.fEndContainer && this.fEndContainer.getNodeType() == 3) {
            if (this.fEndOffset > n + n2) {
                this.fEndOffset = n + (this.fEndOffset - (n + n2));
            } else if (this.fEndOffset > n) {
                this.fEndOffset = n;
            }
        }
    }

    void receiveInsertedText(Node node, int n, int n2) {
        if (node == null) {
            return;
        }
        if (this.fInsertNode == node) {
            return;
        }
        if (node == this.fStartContainer && this.fStartContainer.getNodeType() == 3 && n < this.fStartOffset) {
            this.fStartOffset += n2;
        }
        if (node == this.fEndContainer && this.fEndContainer.getNodeType() == 3 && n < this.fEndOffset) {
            this.fEndOffset += n2;
        }
    }

    void receiveReplacedText(Node node) {
        if (node == null) {
            return;
        }
        if (node == this.fStartContainer && this.fStartContainer.getNodeType() == 3) {
            this.fStartOffset = 0;
        }
        if (node == this.fEndContainer && this.fEndContainer.getNodeType() == 3) {
            this.fEndOffset = 0;
        }
    }

    void receiveSplitData(Node node, Node node2, int n) {
        if (node == null || node2 == null) {
            return;
        }
        if (this.fSplitNode == node) {
            return;
        }
        if (node == this.fStartContainer && this.fStartContainer.getNodeType() == 3 && this.fStartOffset > n) {
            this.fStartOffset -= n;
            this.fStartContainer = node2;
        }
        if (node == this.fEndContainer && this.fEndContainer.getNodeType() == 3 && this.fEndOffset > n) {
            this.fEndOffset -= n;
            this.fEndContainer = node2;
        }
    }

    Node removeChild(Node node, Node node2) {
        this.fRemoveChild = node2;
        Node node3 = node.removeChild(node2);
        this.fRemoveChild = null;
        return node3;
    }

    void removeNode(Node node) {
        int n;
        if (node == null) {
            return;
        }
        if (this.fRemoveChild == node) {
            return;
        }
        Node node2 = node.getParentNode();
        if (node2 == this.fStartContainer && (n = this.indexOf(node, this.fStartContainer)) <= this.fStartOffset) {
            --this.fStartOffset;
        }
        if (node2 == this.fEndContainer && (n = this.indexOf(node, this.fEndContainer)) < this.fEndOffset) {
            --this.fEndOffset;
        }
        if (node2 != this.fStartContainer && node2 != this.fEndContainer) {
            if (this.isAncestorOf(node, this.fStartContainer)) {
                this.fStartContainer = node2;
                this.fStartOffset = this.indexOf(node, node2) - 1;
            }
            if (this.isAncestorOf(node, this.fEndContainer)) {
                this.fEndContainer = node2;
                this.fEndOffset = this.indexOf(node, node2) - 1;
            }
        }
    }

    public void selectNode(Node node) throws RangeException {
        if (this.fDetach) {
            throw new DOMException(11, "DOM011 Invalid state");
        }
        if (!this.isAncestorTypeValid(node)) {
            throw new RangeExceptionImpl(2, "DOM012 Invalid node type");
        }
        Node node2 = node.getParentNode();
        if (node2 != null) {
            this.fStartContainer = node2;
            this.fEndContainer = node2;
            int n = 0;
            Node node3 = node;
            while (node3 != null) {
                ++n;
                node3 = node3.getPreviousSibling();
            }
            this.fStartOffset = n - 1;
            this.fEndOffset = this.fStartOffset + 1;
        }
    }

    public void selectNodeContents(Node node) throws RangeException {
        if (this.fDetach) {
            throw new DOMException(11, "DOM011 Invalid state");
        }
        if (!this.isAncestorTypeValid(node)) {
            throw new RangeExceptionImpl(2, "DOM012 Invalid node type");
        }
        this.fStartContainer = node;
        this.fEndContainer = node;
        Node node2 = node.getFirstChild();
        this.fStartOffset = 0;
        if (node2 == null) {
            this.fEndOffset = 0;
        } else {
            int n = 0;
            Node node3 = node2;
            while (node3 != null) {
                ++n;
                node3 = node3.getNextSibling();
            }
            this.fEndOffset = n;
        }
    }

    public void setEnd(Node node, int n) throws RangeException, DOMException {
        if (this.fDetach) {
            throw new DOMException(11, "DOM011 Invalid state");
        }
        if (!this.isAncestorTypeValid(node)) {
            throw new RangeExceptionImpl(2, "DOM012 Invalid node type");
        }
        this.checkIndex(node, n);
        this.fEndContainer = node;
        this.fEndOffset = n;
    }

    public void setEndAfter(Node node) throws RangeException {
        if (this.fDetach) {
            throw new DOMException(11, "DOM011 Invalid state");
        }
        if (!this.isAncestorTypeValid(node)) {
            throw new RangeExceptionImpl(2, "DOM012 Invalid node type");
        }
        this.fEndContainer = node.getParentNode();
        int n = 0;
        Node node2 = node;
        while (node2 != null) {
            ++n;
            node2 = node2.getPreviousSibling();
        }
        this.fEndOffset = n;
    }

    public void setEndBefore(Node node) throws RangeException {
        if (this.fDetach) {
            throw new DOMException(11, "DOM011 Invalid state");
        }
        if (!this.isAncestorTypeValid(node)) {
            throw new RangeExceptionImpl(2, "DOM012 Invalid node type");
        }
        this.fEndContainer = node.getParentNode();
        int n = 0;
        Node node2 = node;
        while (node2 != null) {
            ++n;
            node2 = node2.getPreviousSibling();
        }
        this.fEndOffset = n - 1;
    }

    public void setStart(Node node, int n) throws RangeException, DOMException {
        if (this.fDetach) {
            throw new DOMException(11, "DOM011 Invalid state");
        }
        if (!this.isAncestorTypeValid(node)) {
            throw new RangeExceptionImpl(2, "DOM012 Invalid node type");
        }
        this.checkIndex(node, n);
        this.fStartContainer = node;
        this.fStartOffset = n;
    }

    public void setStartAfter(Node node) throws RangeException {
        if (this.fDetach) {
            throw new DOMException(11, "DOM011 Invalid state");
        }
        if (!this.isAncestorTypeValid(node)) {
            throw new RangeExceptionImpl(2, "DOM012 Invalid node type");
        }
        this.fStartContainer = node.getParentNode();
        int n = 0;
        Node node2 = node;
        while (node2 != null) {
            ++n;
            node2 = node2.getPreviousSibling();
        }
        this.fStartOffset = n;
    }

    public void setStartBefore(Node node) throws RangeException {
        if (this.fDetach) {
            throw new DOMException(11, "DOM011 Invalid state");
        }
        if (!this.isAncestorTypeValid(node)) {
            throw new RangeExceptionImpl(2, "DOM012 Invalid node type");
        }
        this.fStartContainer = node.getParentNode();
        int n = 0;
        Node node2 = node;
        while (node2 != null) {
            ++n;
            node2 = node2.getPreviousSibling();
        }
        this.fStartOffset = n - 1;
    }

    void signalSplitData(Node node, Node node2, int n) {
        this.fSplitNode = node;
        this.fDocument.splitData(node, node2, n);
        this.fSplitNode = null;
    }

    public void surroundContents(Node node) throws DOMException, RangeException {
        if (node == null) {
            return;
        }
        if (this.fDetach) {
            throw new DOMException(11, "DOM011 Invalid state");
        }
        short s = node.getNodeType();
        if (s == 2 || s == 6 || s == 12 || s == 10 || s == 9 || s == 11) {
            throw new RangeExceptionImpl(2, "DOM012 Invalid node type");
        }
        Node node2 = this.getCommonAncestorContainer();
        Node node3 = this.fStartContainer;
        Node node4 = this.fEndContainer;
        if (this.fStartContainer.getNodeType() == 3) {
            node3 = this.fStartContainer.getParentNode();
        }
        if (this.fEndContainer.getNodeType() == 3) {
            node4 = this.fEndContainer.getParentNode();
        }
        if (node3 != node4) {
            throw new RangeExceptionImpl(1, "DOM013 Bad boundary points");
        }
        DocumentFragment documentFragment = this.extractContents();
        this.insertNode(node);
        node.appendChild(documentFragment);
        this.selectNode(node);
    }

    public String toString() {
        int n;
        if (this.fDetach) {
            throw new DOMException(11, "DOM011 Invalid state");
        }
        Node node = this.fStartContainer;
        Node node2 = this.fEndContainer;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fStartContainer.getNodeType() == 3 || this.fStartContainer.getNodeType() == 4) {
            if (this.fStartContainer == this.fEndContainer) {
                stringBuffer.append(this.fStartContainer.getNodeValue().substring(this.fStartOffset, this.fEndOffset));
                return stringBuffer.toString();
            }
            stringBuffer.append(this.fStartContainer.getNodeValue().substring(this.fStartOffset));
            node = this.nextNode(node, true);
        } else {
            node = node.getFirstChild();
            if (this.fStartOffset > 0) {
                n = 0;
                while (n < this.fStartOffset && node != null) {
                    node = node.getNextSibling();
                    ++n;
                }
            }
            if (node == null) {
                node = this.nextNode(this.fStartContainer, false);
            }
        }
        if (this.fEndContainer.getNodeType() != 3 && this.fEndContainer.getNodeType() != 4) {
            n = this.fEndOffset;
            node2 = this.fEndContainer.getFirstChild();
            while (n > 0 && node2 != null) {
                --n;
                node2 = node2.getNextSibling();
            }
            if (node2 == null) {
                node2 = this.nextNode(this.fEndContainer, false);
            }
        }
        while (node != node2) {
            if (node == null) break;
            if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                stringBuffer.append(node.getNodeValue());
            }
            node = this.nextNode(node, true);
        }
        if (this.fEndContainer.getNodeType() == 3 || this.fEndContainer.getNodeType() == 4) {
            stringBuffer.append(this.fEndContainer.getNodeValue().substring(0, this.fEndOffset));
        }
        return stringBuffer.toString();
    }

    DocumentFragment traverseContents(int n) throws DOMException {
        Node node;
        Node node2;
        if (this.fStartContainer == null || this.fEndContainer == null) {
            return null;
        }
        DocumentFragment documentFragment = this.fDocument.createDocumentFragment();
        Node node3 = this.fStartContainer;
        Node node4 = null;
        Node node5 = null;
        Node node6 = null;
        int n2 = 0;
        Vector vector = new Vector();
        if (this.fStartContainer == this.fEndContainer) {
            if (this.fStartOffset == this.fEndOffset) {
                return documentFragment;
            }
            if (this.fStartContainer.getNodeType() == 3) {
                node4 = this.fStartContainer.cloneNode(false);
                node4.setNodeValue(node4.getNodeValue().substring(this.fStartOffset, this.fEndOffset));
                if (n == 1) {
                    this.deleteData((CharacterData)node3, this.fStartOffset, this.fEndOffset - this.fStartOffset);
                }
                documentFragment.appendChild(node4);
            } else {
                node3 = node3.getFirstChild();
                int n3 = 0;
                n3 = 0;
                while (n3 < this.fStartOffset && node3 != null) {
                    node3 = node3.getNextSibling();
                    ++n3;
                }
                int n4 = this.fEndOffset - this.fStartOffset;
                n3 = 0;
                while (n3 < n4 && node3 != null) {
                    Node node7 = node3.getNextSibling();
                    if (n == 2) {
                        node4 = node3.cloneNode(true);
                        documentFragment.appendChild(node4);
                    } else if (n == 1) {
                        documentFragment.appendChild(node3);
                    }
                    node3 = node7;
                    ++n3;
                }
            }
            return documentFragment;
        }
        Node node8 = this.getCommonAncestorContainer();
        Node node9 = null;
        node3 = this.fStartContainer;
        if (node3.getNodeType() == 3) {
            node4 = node3.cloneNode(false);
            node4.setNodeValue(node4.getNodeValue().substring(this.fStartOffset));
            if (n == 1) {
                this.deleteData((CharacterData)node3, this.fStartOffset, node3.getNodeValue().length() - this.fStartOffset);
            }
        } else {
            node3 = node3.getFirstChild();
            int n5 = 0;
            while (n5 < this.fStartOffset && node3 != null) {
                node3 = node3.getNextSibling();
                ++n5;
            }
            if (node3 == null) {
                node3 = this.fStartContainer;
            }
            if (n == 2) {
                node4 = node3.cloneNode(true);
            } else if (n == 1) {
                node4 = node3;
            }
        }
        Node node10 = null;
        node9 = null;
        while (node3 != node8) {
            node9 = node3.getParentNode();
            if (node9 == node8) {
                node5 = documentFragment;
                node10 = node3;
            } else {
                if (node9 == null) {
                    System.out.println("parent==null: current=" + node3);
                }
                node5 = node9.cloneNode(false);
                if (node6 == null && node9 != node8) {
                    node6 = node9;
                    n2 = 1;
                }
            }
            node2 = null;
            node3 = node3.getNextSibling();
            node5.appendChild(node4);
            while (node3 != null) {
                node2 = node3.getNextSibling();
                if (node3 != null && node9 != node8) {
                    if (n == 2) {
                        node4 = node3.cloneNode(true);
                        node5.appendChild(node4);
                    } else if (n == 1) {
                        node5.appendChild(node3);
                    }
                }
                node3 = node2;
            }
            node3 = node9;
            node4 = node5;
        }
        node2 = null;
        node3 = this.fEndContainer;
        if (node3.getNodeType() == 3) {
            node4 = node3.cloneNode(false);
            node4.setNodeValue(node4.getNodeValue().substring(0, this.fEndOffset));
            if (n == 1) {
                this.deleteData((CharacterData)node3, 0, this.fEndOffset);
            }
        } else {
            if (this.fEndOffset == 0) {
                node3 = this.fEndContainer;
            } else {
                node3 = node3.getFirstChild();
                int n6 = 1;
                while (n6 < this.fEndOffset && node3 != null) {
                    node3 = node3.getNextSibling();
                    ++n6;
                }
                if (node3 == null) {
                    node3 = this.fEndContainer.getLastChild();
                }
            }
            if (n == 2) {
                node4 = node3.cloneNode(true);
            } else if (n == 1) {
                node4 = node3;
            }
        }
        while (node3 != node8 && node3 != null) {
            node9 = node3.getParentNode();
            if (node9 == node8) {
                node5 = documentFragment;
                node2 = node3;
            } else {
                node5 = node9.cloneNode(false);
                if (node6 == null && node9 != node8) {
                    node6 = node9;
                    n2 = -1;
                }
            }
            Node node11 = node3;
            node3 = node9.getFirstChild();
            node5.appendChild(node4);
            node = null;
            while (node3 != node11 && node3 != null) {
                node = node3.getNextSibling();
                if (node3 != null && node9 != node8) {
                    if (n == 2) {
                        node4 = node3.cloneNode(true);
                        node5.appendChild(node4);
                    } else if (n == 1) {
                        node5.appendChild(node3);
                    }
                }
                node3 = node;
            }
            node3 = node9;
            node4 = node5;
        }
        vector.removeAllElements();
        Node node12 = documentFragment.getLastChild();
        node3 = node2.getPreviousSibling();
        node = null;
        while (node3 != node10 && node3 != null) {
            node = node3.getPreviousSibling();
            if (n == 2) {
                node4 = node3.cloneNode(true);
            } else if (n == 1) {
                node4 = node3;
            }
            documentFragment.insertBefore(node4, node12);
            node3 = node;
            node12 = node4;
        }
        if (n == 1) {
            if (node6 == null) {
                this.collapse(true);
            } else if (n2 == 1) {
                this.setStartAfter(node6);
                this.setEndAfter(node6);
            } else if (n2 == -1) {
                this.setStartBefore(node6);
                this.setEndBefore(node6);
            }
        }
        return documentFragment;
    }
}

