// $Header: /home/cvsroot/yaz++/zoom/master-header,v 1.6 2002/10/30 10:03:52 adam Exp $
//
// ZOOM C++ Binding.
// The ZOOM homepage is at http://zoom.z3950.org/
//
// Derived from version 1.0g at
//	http://zoom.z3950.org/bind/cplusplus/zoom-1.0g.hh

#include <stddef.h>		// for size_t

 /*
  * This is a bit stupid.  The fact that our ZOOM-C++ implementation is
  * based on the ZOOM-C implementation is our Dirty Little Secret, and
  * there is in principle no reason why client code need be bothered
  * with it.  Except of course that the public class declarations in
  * C++ have to lay their private parts out for the world to see
  * (oo-er).  Hence the inclusion of <yaz/zoom.h>
  */
 #include <yaz/zoom.h>
 

namespace ZOOM {
  // Forward declarations for type names.
  class YAZ_EXPORT query;
  class YAZ_EXPORT resultSet;
  class YAZ_EXPORT record;

  const char *option (const char *key);
  const char *option (const char *key, const char *val);
  int errcode ();
  char *errmsg ();
  char *addinfo ();

  class YAZ_EXPORT connection {
    ZOOM_connection c;
    friend class resultSet; // so it can use _getYazConnection()
    ZOOM_connection _getYazConnection () const { return c; }
  public:
    connection (const char *hostname, int portnum);
    ~connection ();
    const char *option (const char *key) const;
    const char *option (const char *key, const char *val);
  };

  class query {
      // pure virtual class: derive concrete subclasses from it.
    friend class resultSet; // so it can use _getYazQuery()
    ZOOM_query _getYazQuery () const { return q; }
  protected:
    ZOOM_query q;
  public:
    virtual ~query ();
  };

  class YAZ_EXPORT prefixQuery : public query {
  public:
    prefixQuery (const char *pqn);
    ~prefixQuery ();
  };

  class YAZ_EXPORT CCLQuery : public query {
  public:
    CCLQuery (const char *ccl, void *qualset);
    ~CCLQuery ();
  };

  class YAZ_EXPORT resultSet {
    connection &owner;
    ZOOM_resultset rs;
  public:
    resultSet (connection &c, const query &q);
    ~resultSet ();
    const char *option (const char *key) const;
    const char *option (const char *key, const char *val);
    size_t size () const;
    const record *getRecord (size_t i) const;
  };

  class YAZ_EXPORT record {
    const resultSet *owner;
    ZOOM_record r;
    friend class resultSet; // so it can use this constructor
    record::record (const resultSet *rs, ZOOM_record rec):
	owner (rs), r (rec) {}
  public:
    ~record ();
    enum syntax {
      UNKNOWN, GRS1, SUTRS, USMARC, UKMARC, XML
    };
    record *clone () const;
    syntax recsyn () const;
    const char *render () const;
    const char *rawdata () const;
  };

  class YAZ_EXPORT exception {
  protected:
    int code;
  public:
    exception (int code);
    int errcode () const;
    const char *errmsg () const;
  };

  class YAZ_EXPORT systemException: public exception {
  public:
    systemException ();
    int errcode () const;
    const char *errmsg () const;
  };

  class YAZ_EXPORT bib1Exception: public exception {
    const char *info;
  public:
    ~bib1Exception ();
    bib1Exception (int errcode, const char *addinfo);
    int errcode () const;
    const char *errmsg () const;
    const char *addinfo () const;
  };

  class YAZ_EXPORT queryException: public exception {
    const char *q;
  public:
    ~queryException ();
    enum {
     PREFIX = 1,
     CCL = 2
    };
    queryException (int qtype, const char *source);
    int errcode () const;
    const char *errmsg () const;
    const char *addinfo () const;
  };
}
